NOTE "Define the EOS fluid characterization to be tuned to PVT and viscosity data."

-- Specify the characterization name by predefining the CharName macro
-- and report the essential characterization parameters (if LaTeX is on):

CHARACTERIZATION "?CharName?" LaTeX

-- Set up the component table with all of the necessary and desired properties.
-- All properties will be filled in by library values, correlations, and/or regression variables.
-- Indicate the (non-essential) properties to be reported tabularly (if LaTeX is on) and the
-- properties to be plotted (Y vs X, if plotting is on):

COMPONENT    LMW    MW    SG    TB(C)    TC(K)    PC(BARA)    AF    VTRAN    ZC    ZCVIS    VIS(cp)    PCHOR    VC(ft3/lbmol)   VCVIS(ft3/lbmol)
----------  -----  ----  ----  -------  -------  ----------  ----  -------  ----  -------  ---------  -------
LTX                       LTX   LTX                                          LTX             LTX
----------  -----  ----  ----  -------  -------  ----------  ----  -------  ----  -------  ---------  -------
                     X     Y      Y        Y          Y        Y      Y       Y      Y         Y         Y
----------  -----  ----  ----  -------  -------  ----------  ----  -------  ----  -------  ---------  -------
N2        
CO2       
C1        
C2        
C3        
I-C4      
N-C4      
I-C5      
N-C5      
C6
C7
C8
C9
C10
C11       
C12       
C13       
C14       
C15       
C16       
C17       
C18       
C19       
C20       
C21       
C22       
C23       
C24       
C25       
C26       
C27       
C28       
C29       
C30+
END; of the component table.

-- The MW of the C30+ component is to be specified by a variable named MW30:

REPLACE MW of C30+ by MW30

-- Fill in all non-specified, non-library properties with correlations:

CORRELATE

-- Use a ramp function, with slope PcRamp, pivoting at 25 bar, to modify
-- the critical pressure of all C10+ components, with C30+ receiving the most
-- change and C10 the least. If PcRamp > 1, the critical pressures will be decreased.
-- If PcRamp < 1, they will be increased. If PcRamp = 1, they will not be modified.

DECREASE PC of C10 to C30+ by 25 bar
MULTIPLY PC of C10 to C30+ by PcRamp
INCREASE PC of C10 to C30+ by 25 bar

-- Initialize all binary interaction parameters to zero:

REPLACE BIPs of N2 to C30+ with N2 to C30+ by 0

-- Replace the N2/CO2, N2/C1, and CO2/C1 BIPs with values determined elsewhere
-- from binary PVT data:

REPLACE BIP of N2  with CO2 by -0.012
REPLACE BIP of N2  with C1  by  0.036
REPLACE BIP of CO2 with C1  by  0.096

-- Replace the other N2 and CO2 binaries with a generally
-- accepted value of 0.1 (with so little N2 and CO2 in any of the fluids,
-- this value is not very critical):

REPLACE BIPs of N2  with C2 to C30+ by 0.1
REPLACE BIPs of CO2 with C2 to C30+ by 0.1

-- Use the original Chueh correlation, with exponents CH_1 and CH2, to
-- set the binary interaction components involving C1 and C2, respectively,
-- with all other hydrocarbon components:

CHUEH   C1 with C1 to C30+ by CH_1
CHUEH   C2 to C30+ with C2 to C30+ by CH_2

-- Increase the BIPs of C30+ with all other components by B_H_ALL.
-- This will improve the chances of matching data from swelling experiments.
-- If done to extremes, however, it will increase the chances of introducing
-- three-phase behavior at temperatures of interest.

INCREASE BIPS of C30+ with N2 to C30+ by B_H_ALL

END; of characterization.

-- Specify lumping rules for experimental component groupings:

LUMP C2-C5:   C2    6*1
LUMP C6-C7:   C6 C7
LUMP C8-C9:   C8 C9
LUMP C10-C13: C10   4*1
LUMP C14-C19: C14   6*1
LUMP C20-C29: C20  10*1
LUMP C4+:     I-C4 29*1
LUMP C6+:     C6   25*1
